<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8" />
  <link rel="icon" type="image/x-icon" href="https://kenzieshane.my.id/profile.png">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Kenzie Shane's Gallery</title>
      <!-- Basic SEO -->
  <meta name="description" content="KenzieShane's Gallery!" />

  <!-- Open Graph / Facebook / WhatsApp -->
  <meta property="og:type" content="website" />
  <meta property="og:url" content="https://kenzieshane.my.id/index.html" />
  <meta property="og:title" content="KenzieShane's Gallery!" />
  <meta property="og:description" content="KenzieShane's web!" />
  <meta property="og:image" content="https://kenziehshane.my.id/profile.png" />
<link rel="preconnect" href="https://fonts.googleapis.com">
<link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
<link href="https://fonts.googleapis.com/css2?family=UnifrakturCook:wght@700&display=swap" rel="stylesheet">

  <!-- Twitter -->
  <meta name="twitter:card" content="summary_large_image" />
  <meta name="twitter:url" content="https://kenzieshane.my.id/index.html" />
  <meta name="twitter:title" content="KenzieShane's Gallery!" 
  <meta name="twitter:description" content="KenzieShane's web!" />
  <meta name="twitter:image" content="https://kenziehshane.my.id/profile.png" />
 <link rel="stylesheet" href="new_ks.css">

    <style>
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
            font-family: sans-serif;
        }
        
        .unifrakturcook-bold {
  font-family: "UnifrakturCook", cursive;
  font-weight: 700;
  font-style: normal;
}

    body {
      margin: 0;
      font-family: sans-serif;
      background: linear-gradient(to bottom, #fcd9c2, #785944);
      color: #FFFFFF;
    }

    /* Navbar */
    navx {
        left: 0;
        right: 0;
        position: fixed;
        top: 0;
        z-index: 1000;
           background-image: linear-gradient(to bottom, #e6d3a7, #c9a66b);
      padding: 1rem 2rem;
      box-shadow: 0 2px 4px rgba(0,0,0,0.1);
      display: flex;
      justify-content: space-between;
      align-items: center;
      color: #333
    }

    navx h1 {
      margin: 0;
      font-size: 1.2rem;
    }

    navx ul {
      list-style: none;
      display: flex;
      gap: 1rem;
      margin: 0;
      padding: 0;
    }

    navx ul li a {
      text-decoration: none;
      color: #333;
    }

    navx ul li a:hover {
      color: #0077cc;
    }
        
        .container {
            max-width: 1200px;
            margin: 0 auto;
            padding: 20px;
        }
        
        h1 {
            font-size: 2.5rem;
            margin-bottom: 10px;
        }
        
        .gallery {
            display: grid;
            grid-template-columns: repeat(auto-fill, minmax(250px, 1fr));
            gap: 20px;
            margin-bottom: 30px;
        }
        
        .gallery-item {
            background: white;
            border-radius: 8px;
            overflow: hidden;
            box-shadow: 0 3px 10px rgba(0, 0, 0, 0.1);
            transition: transform 0.3s ease, box-shadow 0.3s ease;
            cursor: pointer;
        }
        
        .gallery-item:hover {
            transform: translateY(-5px);
            box-shadow: 0 5px 15px rgba(0, 0, 0, 0.2);
        }
        
        .gallery-item img {
            width: 100%;
            height: 180px;
            object-fit: cover;
            display: block;
        }
        
        .gallery-item p {
            padding: 15px;
            text-align: center;
            color: #333;
            font-weight: 500;
        }
        
        .modal {
            display: none;
            position: fixed;
            top: 0;
            left: 0;
            width: 100%;
            height: 100%;
            background-color: rgba(0, 0, 0, 0.9);
            z-index: 100;
            justify-content: center;
            align-items: center;
        }
        
        .modal-content {
            max-width: 90%;
            max-height: 90%;
        }
        
        .modal-content img {
            width: 100%;
            height: auto;
            border-radius: 8px;
        }
        
        .close {
            position: absolute;
            top: 20px;
            right: 30px;
            color: white;
            font-size: 40px;
            cursor: pointer;
            transition: color 0.3s;
        }
        
        .close:hover {
            color: #ff5252;
        }
        
        .no-images {
            grid-column: 1 / -1;
            text-align: center;
            padding: 40px;
            background: white;
            border-radius: 8px;
            box-shadow: 0 3px 10px rgba(0, 0, 0, 0.1);
        }
        
        footer {
            text-align: center;
            margin-top: 30px;
            padding: 20px;
            color: #666;
        }
        
        @media (max-width: 768px) {
            .gallery {
                grid-template-columns: repeat(auto-fill, minmax(200px, 1fr));
            }
        }
        
        @media (max-width: 480px) {
            .gallery {
                grid-template-columns: 1fr;
            }
        }
    </style>
</head>
<body>
<navx>
  <img width=20px src=profile.png>
    <h1 class=unifrakturcook-bold>KenzieShane's</h1>
    <ul>
    <li></li>
      <li><a href="/">Home</a></li>
      <li><a href="about.html">About</a></li>
      <li><a href="http://books.kenzieshane.my.id">Books</a></li>
    </ul>
  </navx>
  <br>
  <br>
    <div class="container">
        <header>
            <h1>KenzieShane's Gallery</h1>
            <p>My Photos that I took!</p>
        </header>
        
        <div class="gallery">
            <?php
$photoDir = 'assets/photos/';
$imageFiles = [];

// ========== 1. Get Local Images ==========
if (is_dir($photoDir)) {
    $files = scandir($photoDir);
    foreach ($files as $file) {
        $filePath = $photoDir . $file;
        if (is_file($filePath)) {
            $ext = strtolower(pathinfo($filePath, PATHINFO_EXTENSION));
            if (in_array($ext, ['jpg', 'jpeg', 'png', 'gif', 'webp'])) {
                $imageFiles[] = $photoDir . $file;
            }
        }
    }
}

// ========== 2. Get Remote Images ==========
$remoteApi = "https://ks-login.kesug.com/assets/list-images.php";
$remoteData = @file_get_contents($remoteApi);

if ($remoteData !== false) {
    $remoteImages = json_decode($remoteData, true);
    if (is_array($remoteImages)) {
        $imageFiles = array_merge($imageFiles, $remoteImages);
    }
}

// ========== 3. Display Gallery ==========
if (count($imageFiles) > 0) {
    foreach ($imageFiles as $image) {
        echo '<div class="gallery-item" onclick="openModal(\'' . $image . '\')">';
        echo '<a href="' . $image . '">';
        echo '<img src="' . $image . '" alt="' . basename($image) . '">';
        echo '</a>';
        echo '<p>' . basename($image) . '</p>';
        echo '</div>';
    }
} else {
    echo '<div class="no-images">';
    echo '<h2>No images found</h2>';
    echo '<p>Please add images to your local or remote directory</p>';
    echo '</div>';
}
?>

        </div>
        
        <div id="modal" class="modal">
            <span class="close" onclick="closeModal()">&times;</span>
            <img class="modal-content" id="modalImage">
        </div>
        
          <footer>
            <p>©<script type="text/javascript">document. write( new Date(). getFullYear() );</script> KenzieShane</p>
        </footer>
    </div>

    <script>
        function openModal(src) {
            document.getElementById('modal').style.display = 'flex';
    </body>
    
</html>